varying vec2 f_texcoord;

uniform sampler2D texture;
uniform sampler2D texture_noise;

uniform vec2 rnd_offset_uv_0, rnd_offset_uv_1;
uniform float interpol_factor;

const float noiseIntensity = 0.015;
#define MONOCHROMATIC

void main(void)
{
	vec3 color = texture2D(texture, f_texcoord).rgb;
	vec3 colorNoise0 = texture2D(texture_noise, f_texcoord+rnd_offset_uv_0).rgb;
	vec3 colorNoise1 = texture2D(texture_noise, f_texcoord+rnd_offset_uv_1).rgb;

	#ifdef MONOCHROMATIC
	float noise = mix(colorNoise0.r, colorNoise1.r, interpol_factor);
	#else
	vec3 noise = mix(colorNoise0, colorNoise1, interpol_factor);
	#endif

	vec3 colorResult = color + noiseIntensity * (2.0*noise-1.0);

	gl_FragColor = vec4(colorResult, 1.0);
}
